<?php
namespace App\Http\Controllers;

use App\Models\DiagnosisPreset;
use Illuminate\Http\Request;
use Inertia\Inertia;

class DiagnosisPresetController extends Controller
{
    public function index(Request $request)
    {
        $query = DiagnosisPreset::query();

        if ($search = $request->input('search')) {
            $query->where('name', 'like', "%{$search}%")
                ->orWhere('icd_code', 'like', "%{$search}%");
        }

        $diagnoses = $query->orderBy('name')
            ->paginate(10)
            ->withQueryString();

        return Inertia::render('DiagnosisPresets/Index', [
            'diagnoses' => $diagnoses,
            'filters'   => $request->only('search'),
        ]);
    }

    public function create()
    {
        return Inertia::render('DiagnosisPresets/Create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name'     => ['required', 'string', 'max:255'],
            'icd_code' => ['required', 'string', 'max:20'],
            'description' => ['nullable', 'string', 'max:1000'],
        ]);

        DiagnosisPreset::create($validated);

        return redirect()->route('diagnosis-presets.index')->with('success', 'Diagnosis added.');
    }

    public function edit(DiagnosisPreset $diagnosisPreset)
    {
        return Inertia::render('DiagnosisPresets/Edit', [
            'diagnosis' => $diagnosisPreset,
        ]);
    }

    public function update(Request $request, DiagnosisPreset $diagnosisPreset)
    {
        $validated = $request->validate([
            'name'     => ['required', 'string', 'max:255'],
            'icd_code' => ['required', 'string', 'max:20'],
            'description' => ['nullable', 'string', 'max:1000'],
        ]);

        $diagnosisPreset->update($validated);

        return redirect()->route('diagnosis-presets.index')->with('success', 'Diagnosis updated.');
    }

    public function destroy(DiagnosisPreset $diagnosisPreset)
    {
        $diagnosisPreset->delete();

        return redirect()->back()->with('success', 'Diagnosis deleted.');
    }
}
