<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class KioskController extends Controller
{
    public function index(Request $request)
    {
        $allowed = $request->user()?->enabledModuleSlugs() ?? [];

        // If user has exactly one module, skip the kiosk entirely
        if (count($allowed) === 1) {
            $only = $allowed[0];
            $request->session()->put('active_module', $only);
            return redirect()->route($this->moduleRoute($only));
        }

        return inertia('Kiosk/Index', [
            'active_module' => $request->session()->get('active_module'),
            'allowed'       => $allowed,
        ]);
    }

    public function choose(Request $request)
    {
        $allowed = $request->user()?->enabledModuleSlugs() ?? [];

        $validated = $request->validate([
            'module' => ['required', Rule::in($allowed)], // only allow what the user has
        ]);

        $request->session()->put('active_module', $validated['module']);

        return redirect()->route($this->moduleRoute($validated['module']));
    }

    public function reset(Request $request)
    {
        $request->session()->forget('active_module');
        return redirect()->route('kiosk.index');
    }

    protected function moduleRoute(string $slug): string
    {
        return match ($slug) {
            'dental'     => 'dental.dashboard',
            'chronics'   => 'chronics.dashboard',
            'secondary'  => 'secondary.dashboard', // ✅ Secondary Health
            'medicals'   => 'medicals.dashboard',  // ✅ Medicals
            'primary'    => 'dashboard',
            default      => 'dashboard',
        };
    }
}
