<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckApiKey
{
    public function handle(Request $request, Closure $next)
    {
        // Read comma-separated keys directly from .env
        $allowed = collect(explode(',', (string) env('EXTERNAL_API_KEYS', '')))
            ->map(fn($v) => trim($v))
            ->filter()
            ->values()
            ->all();

        $provided = $request->header('X-API-Key');

        if (!$provided || !in_array($provided, $allowed, true)) {
            return response()->json([
                'error'   => 'Unauthorized',
                'message' => 'Valid API key required in X-API-Key header.',
            ], 401);
        }

        return $next($request);
    }
}
