<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureActiveModule
{
    /**
     * Ensure the current session('active_module') matches the required module.
     * Usage in routes: ->middleware('module:dental') or ->middleware('module:chronics')
     */
    public function handle(Request $request, Closure $next, string $required)
    {
        $active = $request->session()->get('active_module');

        if ($active !== $required) {
            // Optionally keep intended URL to return after switching
            return redirect()
                ->route('kiosk.index')
                ->with('warning', "Please choose the {$required} module to access this area.");
        }

        return $next($request);
    }
}
