<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureChronicsModule
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();
        if (!$user || !$user->hasModuleAccess('chronics')) {
            return redirect()->route('kiosk.index')
                ->with('warning', 'You do not have access to the Chronics module.');
        }

        if ($request->session()->get('active_module') !== 'chronics') {
            return redirect()->route('kiosk.index')
                ->with('warning', 'Please choose the Chronics module to access this area.');
        }

        return $next($request);
    }
}
