<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureDentalModule
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();
        if (!$user || !$user->hasModuleAccess('dental')) {
            return redirect()->route('kiosk.index')
                ->with('warning', 'You do not have access to the Dental module.');
        }

        if ($request->session()->get('active_module') !== 'dental') {
            return redirect()->route('kiosk.index')
                ->with('warning', 'Please choose the Dental module to access this area.');
        }

        return $next($request);
    }
}
