<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureMedicalsModule
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        if (!$user || !$user->hasModuleAccess('medicals')) {
            return redirect()->route('kiosk.index')
                ->with('warning', 'You do not have access to the Medicals module.');
        }

        if ($request->session()->get('active_module') !== 'medicals') {
            return redirect()->route('kiosk.index')
                ->with('warning', 'Please choose the Medicals module to access this area.');
        }

        return $next($request);
    }
}
