<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureSecondaryHealthModule
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        if (!$user || !$user->hasModuleAccess('secondary')) {
            return redirect()->route('kiosk.index')
                ->with('warning', 'You do not have access to the Secondary Health module.');
        }

        if ($request->session()->get('active_module') !== 'secondary') {
            return redirect()->route('kiosk.index')
                ->with('warning', 'Please choose the Secondary Health module to access this area.');
        }

        return $next($request);
    }
}
