<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureSuperadmin
{
    /**
     * Handle an incoming request.
     *
     * Only allow users with role 'superadmin'.
     * Otherwise redirect back (or dashboard if no referrer), or return 403 JSON for API/AJAX.
     */
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();

        // Not logged in? Let the auth middleware handle it, or kick to login here:
        if (!$user) {
            return redirect()->route('login');
        }

        // Your project casts role to App\Enums\UserRole; compare the enum value.
        $isSuperadmin = $user->role?->value === 'superadmin';

        if ($isSuperadmin) {
            return $next($request);
        }

        // If the client expects JSON (API/AJAX), return 403 JSON.
        if ($request->expectsJson()) {
            return response()->json([
                'message' => 'This action is restricted to superadmins.',
            ], 403);
        }

        // Otherwise redirect back with a message; fall back to dashboard if no referer.
        $fallback = route('dashboard');
        return redirect()->back(fallback: $fallback)
            ->with('warning', 'You are not authorized to perform this action (superadmin only).');
    }
}
