<?php

// app/Http/Middleware/ShareActiveModule.php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Inertia\Inertia;

class ShareActiveModule
{
    public function handle(Request $request, Closure $next)
    {
        // Prefer route name when available (robust), else fall back to URL prefix
        $routeName = optional($request->route())->getName() ?? '';
        $path      = $request->path(); // e.g. 'chronics/patients'

        $active = 'primary';

        if (Str::startsWith($routeName, 'chronics.') || Str::startsWith($path, 'chronics')) {
            $active = 'chronics';
        } elseif (Str::startsWith($routeName, 'dental.') || Str::startsWith($path, 'dental')) {
            $active = 'dental';
        } elseif (Str::startsWith($routeName, 'medicals.') || Str::startsWith($path, 'medicals')) {
            $active = 'medicals';
        } elseif (Str::startsWith($routeName, 'secondary.') || Str::startsWith($path, 'secondary')) {
            $active = 'secondary';
        }

        // Make it available to every Inertia page render on this request
        Inertia::share(['active_module' => $active]);

        return $next($request);
    }
}
