<?php
namespace App\Mail;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DailyDispenseReportMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Carbon $forDate,
        public string $attachmentPath,
        public string $attachmentName,
        public ?string $filtersLine = null
    ) {}

    public function build()
    {
        $subject = 'Daily Dispensations — ' . $this->forDate->isoFormat('ddd, D MMM YYYY');

        return $this->subject('Daily Dispensations — ' . $this->forDate->isoFormat('ddd, D MMM YYYY'))
            ->view('emails.daily_dispensations_html', [
                'forDate'     => $this->forDate,
                'filtersLine' => $this->filtersLine ?? null,
            ])
            ->attach($this->attachmentPath, [
                'as'   => $this->attachmentName,
                'mime' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            ]);

    }
}
