<?php

namespace App\Mail;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DailyNurseConsultationsMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Carbon $forDate,
        public string $attachmentPath,
        public string $attachmentName,
        public ?string $filtersLine = null
    ) {}

    public function build()
    {
        return $this->subject('Daily Nurse Consultations — '.$this->forDate->isoFormat('ddd, D MMM YYYY'))
            ->view('emails.daily_nurse_consultations', [
                'forDate'     => $this->forDate,
                'filtersLine' => $this->filtersLine,
            ])
            ->attach($this->attachmentPath, [
                'as'   => $this->attachmentName,
                'mime' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            ]);
    }
}
