<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CentralStore extends Model
{
    protected $fillable = [
        'name',
        'location',
        'address',
        'latitude',
        'longitude',
        'description',
    ];

    /**
     * A central store has many medication batches.
     */
    public function medicationBatches(): HasMany
    {
        return $this->hasMany(MedicationBatch::class);
    }

}
