<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ChronicDispensation extends Model
{
    protected $table = 'chronic_dispensations';

    protected $fillable = [
        'patient_id',
        'frequency',
        'route',
        'duration',
        'clinic_medication_stock_id',
        'nurse_medication_stock_id',
        'dispensed_by',
        'quantity',
        'dispensed_at',
        'notes',
    ];

    protected $casts = [
        'dispensed_at' => 'datetime',
        'quantity'     => 'decimal:2',
    ];

    /* ── Relations ───────────────────────────────────── */

    public function patient(): BelongsTo
    {
        return $this->belongsTo(Patient::class);
    }

    public function clinicMedicationStock(): BelongsTo
    {
        return $this->belongsTo(ClinicMedicationStock::class);
    }

    public function nurseMedicationStock(): BelongsTo
    {
        return $this->belongsTo(NurseMedicationStock::class, 'nurse_medication_stock_id');
    }

    public function dispensedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'dispensed_by');
    }

    // Alias for consistency with your Dispensation model naming:
    public function stock(): BelongsTo
    {
        return $this->belongsTo(ClinicMedicationStock::class, 'clinic_medication_stock_id');
    }
}
