<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ClinicMedicationStock extends Model
{
    protected $fillable = [
        'clinic_id',
        'medication_batch_id',
        'quantity',
    ];

    public function clinic(): BelongsTo
    {
        return $this->belongsTo(Clinic::class);
    }

    public function medicationBatch(): BelongsTo
    {
        return $this->belongsTo(MedicationBatch::class, 'medication_batch_id');
    }

    public function getMedicationNameAttribute(): ?string
    {
        return $this->medicationBatch?->medication?->name;
    }
}
