<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Company extends Model
{
    protected $fillable = [
        'name',
        'address',
        'site_telephone',
        'company_email',
        'contact_person',
        'province',
        'designation',
        'contact_number',
        'is_private',
    ];

    protected $casts = [
        'is_private' => 'boolean',
    ];

    public function usersWithAccess(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'user_company_accesses')->withTimestamps();
    }

    /** NEW: Direct patients whose `company_id` matches this company */
    public function patients(): HasMany
    {
        return $this->hasMany(Patient::class);
    }
}
