<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Dispensation extends Model
{
    protected $fillable = [
        'patient_id',
        'consultation_id',
        'frequency',
        'route',
        'duration',
        'clinic_medication_stock_id',
        'nurse_medication_stock_id',
        'dispensed_by',
        'quantity',
        'dispensed_at',
        'notes',
    ];

    public function consultation()
    {
        return $this->belongsTo(Consultation::class);
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }

    public function clinicMedicationStock()
    {
        return $this->belongsTo(ClinicMedicationStock::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'dispensed_by');
    }

    public function stock()
    {
        return $this->belongsTo(ClinicMedicationStock::class, 'clinic_medication_stock_id');
    }

    public function dispensedBy()
    {
        return $this->belongsTo(User::class, 'dispensed_by');
    }


     public function nurseMedicationStock()
    {
        return $this->belongsTo(NurseMedicationStock::class, 'nurse_medication_stock_id');
    }

    
    public function clinic_medication_stock()
    {
        return $this->belongsTo(ClinicMedicationStock::class);
    }

}
