<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ImagingReferral extends Model
{
    protected $fillable = [
        'consultation_id',
        'patient_id',
        'referrer_id',
        'provider',
        'requested_at',
        'exams',
        'region_of_interest',
        'history',
        'lmp',
        'is_pregnant',
        'referring_doctor_name',
        'notes',
        'status',
        'attachment_path',
    ];

    protected $casts = [
        'requested_at' => 'datetime',
        'lmp'          => 'date',
        'is_pregnant'  => 'boolean',
        'exams'        => 'array',
    ];

    // Relationships
    public function consultation(): BelongsTo
    {return $this->belongsTo(Consultation::class);}
    public function patient(): BelongsTo
    {return $this->belongsTo(Patient::class);}
    public function referrer(): BelongsTo
    {return $this->belongsTo(User::class, 'referrer_id');}
}
