<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LabReferral extends Model
{
    protected $fillable = [
        'consultation_id',
        'patient_id',
        'referrer_id',
        'provider',
        'lab_ref_no',
        'requested_at',
        'clinical_data',
        'specimen_types',
        'tests_requested',
        'medical_aid_provider',
        'membership_no',
        'membership_suffix',
        'relation_to_member',
        'copies_to',
        'patient_bled_by',
        'tubes_edta',
        'tubes_sst',
        'tubes_plain',
        'tubes_fluoride',
        'tubes_citrate',
        'tubes_heparin',
        'collected_at',
        'received_by',
        'received_at',
        'referral_notes',
        'status',
        'attachment_path',
    ];

    protected $casts = [
        'requested_at'   => 'datetime',
        'collected_at'   => 'datetime',
        'received_at'    => 'datetime',
        'specimen_types' => 'array',
        'tubes_edta'     => 'integer',
        'tubes_sst'      => 'integer',
        'tubes_plain'    => 'integer',
        'tubes_fluoride' => 'integer',
        'tubes_citrate'  => 'integer',
        'tubes_heparin'  => 'integer',
    ];

    public function consultation(): BelongsTo { return $this->belongsTo(Consultation::class); }
    public function patient(): BelongsTo { return $this->belongsTo(Patient::class); }
    public function referrer(): BelongsTo { return $this->belongsTo(User::class, 'referrer_id'); }
}
