<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Log extends Model
{
    protected $fillable = [
        'user_id',
        'user_name',
        'action',
        'loggable_type',
        'loggable_id',
        'description',
        'old_values',
        'new_values',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'old_values' => 'array',
        'new_values' => 'array',
    ];

    // Polymorphic relation to the affected model/entity
    public function loggable(): MorphTo
    {
        return $this->morphTo();
    }

    // Optional relation to user who did the action
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
