<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MedicalFundMember extends Model
{
    protected $fillable = [
        'employee_number',
        'first_name',
        'middle_name',
        'surname',
        'company_id',
        'tag',
    ];

    public function company()
    {
        return $this->belongsTo(\App\Models\Company::class);
    }

    // Quality-of-life
    protected $casts = [
        // none needed now
    ];

    public function getFullNameAttribute(): string
    {
        return trim(sprintf('%s %s %s', $this->first_name, $this->middle_name, $this->surname));
    }
}
