<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdditionalTest extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'results_investigation_id',
        'sputum',
        'ecg',
        'echo',
        'chest_scan',
        'other',
        'other_details',
    ];
    protected $casts = [
        'sputum' => 'boolean',
        'ecg' => 'boolean',
        'echo' => 'boolean',
        'chest_scan' => 'boolean',
        'other' => 'boolean',
    ];

    public function results_investigation()
    {
        return $this->belongsTo(ResultsInvestigations::class);
    }
}
