<?php
namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Attendee extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'id',
        'company_id',
        'swab_number',
        'x_ray_status',
        'time_of_entry',
        'employee_number',
        'date_of_birth',
        'first_name',
        'last_name',
        'gender',
        'national_id',
        'phone_number',
        'location',
        'created_at',
        'updated_at',

    ];

    // ...
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($attendee) {
            $patient = $attendee->patient;
            if ($patient) {

                $certificates = $patient->certificates;
                if ($certificates) {
                    $certificates->each(function ($certificate) {
                        $certificate->delete();
                    });
                }

                $physicalExams = $patient->physical_exams;
                if ($physicalExams) {
                    $physicalExams->each(function ($physicalExam) {
                        $physicalExam->delete();
                    });
                }
                $xrays = $patient->xrays;
                if ($xrays) {
                    $xrays->each(function ($xray) {
                        $xray->delete();
                    });
                }
                $illnesses = $patient->illnesses;
                if ($illnesses) {
                    $patient->illnesses()->detach();
                }
                $tobaccoUses = $patient->tobacco_uses;
                if ($tobaccoUses) {
                    $patient->tobacco_uses()->detach();
                }
                $patient->delete();
            }
        });
    }

    public function scopeSearch($query, $search)
    {
        if ($search) {
            $query->where(function ($query) use ($search) {
                $query->where('swab_number', 'LIKE', "%$search%")
                    ->orWhere('first_name', 'LIKE', "%$search%")
                    ->orWhere('last_name', 'LIKE', "%$search%")
                    ->orWhere('national_id', 'LIKE', "%$search%");
            });
        }
        return $query;
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function patient()
    {
        return $this->hasOne(Patient::class);
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'attendee_category');
    }
}
