<?php

namespace App\Models\Medicals;



use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Booking extends MedicalsModel
{
    use HasFactory;


    protected $fillable = [
        'company_id',
        'employee_number',
        'first_name',
        'last_name',
        'date_of_birth',
        'gender',
        'national_id',
        'phone_number',
        'exam_purpose',
        'category',      // New field
        'x_ray_status',  // New field
        'country_code',  // New field
        'last_x_ray',    // New field
        'booking_date',  // New field
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }
}
