<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CardioVascular extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'apex_beat_position',
        'rate',
        'rhythm',
        'sound',
        'murmurs',
        'bp_sys',
        'bp_dia',
        'exercise_tolerance'        
    ];

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
}
