<?php

// app/Models/Medicals/Company.php
namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Relations\HasMany;

class Company extends MedicalsModel
{
    protected $table = 'companies';

    protected $fillable = [
        'company_name',
        'address',
        'site_telephone',
        'company_email',
        'contact_person',
        'province',
        'designation',
        'contact_number',
    ];

    // Make sure these related models also live under App\Models\Medicals\*
    public function attendees(): HasMany
    {
        return $this->hasMany(\App\Models\Medicals\Attendee::class);
    }

    public function patients(): HasMany
    {
        return $this->hasMany(\App\Models\Medicals\Patient::class);
    }

    public function certificate_batches(): HasMany
    {
        return $this->hasMany(\App\Models\Medicals\CertificateBatch::class);
    }
}
