<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Dnote extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'id',
        'name',
        'dispatched_date',
        'dispatched'

    ];


    public function dNoteItems()
    {
        return $this->hasMany(DnoteItems::class);
    }


    public function scopeAdvancedSearch($query, $company, $name, $type, $startDate, $endDate)
    {
        return $query->when($company, function ($query, $company) {
            return $query->where('name', 'like', '%' . $company . '%');
        })
            ->when($name, function ($query, $name) {
                return $query->where('name', 'like', '%' . $name . '%');
            })
            ->when($type, function ($query, $type) {
                return $query->where('type', 'like', '%' . $type . '%');
            })
            ->when($startDate, function ($query, $startDate) {
                return $query->where(function ($query) use ($startDate) {
                    $query->where('name', 'like', '%(' . $startDate . ')%');
                });
            })
            ->when($endDate, function ($query, $endDate) {
                return $query->where(function ($query) use ($endDate) {
                    $query->where('name', 'like', '%(' . $endDate . ')%');
                });
            });
    }
}
