<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class FRemarks extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'id',
        "patient_id",
        "previous_health_issues",
        "year_of_diagnosis",
        "comment",
        "chest_x_ray",
        "remarks",
        "swab_result",
        "fit_to_work",
    ];


    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }


    public function medical_record(): BelongsTo
    {
        return $this->belongsTo(MedicalRecord::class);
    }
}
