<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HealthyQuestionnaire extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'pneumoconiosis_id',
        'dusty_occupation',
        'occupation_details',
        'years_worked',
        'exposure',
    ];


    public function pneumoconiosis()
    {
        return $this->belongsTo(Pneumoconiosis::class);
    }

    public function symptom_test()
    {
        return $this->hasOne(SymptomTest::class);
    }

    public function condition_test()
    {
        return $this->hasOne(ConditionTest::class);
    }

    public function physical_test()
    {
        return $this->hasOne(PhysicalTest::class);
    }

    public function systems_check()
    {
        return $this->hasOne(SystemsCheck::class);
    }

    public function smokingHistory()
    {
        return $this->hasOne(SmokingHistory::class);
    }
}
