<?php

namespace App\Models\Medicals;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Log extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'action',
        'model_type',
        'model_id',
        'description',
        'data',
        'metadata',
        'platform',
        'browser',
        'ip_address',
        'user_id',
    ];

    protected $casts = [
        'data'     => 'array',
        'metadata' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function model()
    {
        return $this->morphTo(null, 'model_type', 'model_id');
    }
}
