<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MedicalHistory extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'serious_injury',
        'injury_details',
        'admitted',
        'admission_details',
        'allergies',
        'allergies_details',
        'health_state',
        'alcohol',
        'alcohol_per_day',
        'alcohol_per_week',
        'exercise'

    ];

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
}
