<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class MedicalRecord extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'year_of_exam',
        'f_remarks_id',
        'xray_id',
        'swab_id',
        'hygiene_id',
        'referral',
        'laboratory',
        'radiology',
        'prescription',
        'exam_location',
        'created_at',
        'updated_at'
    ];



    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }

    public function remarks(): HasOne
    {
        return $this->hasOne(FRemarks::class);
    }

    public function xray(): HasOne
    {
        return $this->hasOne(Xray::class);
    }

    public function hygiene(): HasOne {
        return $this->hasOne(Hygiene::class);
    }

    public function swab(): HasOne {
        return $this->hasOne(Swab::class);
    }
}
