<?php
namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Patient extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'attendee_id',
        'company_id',
        'exam_purpose',
        'previous_health_issues',
        'year_of_diagnosis',
        'chest_x_ray_normal',
        'general_observation',
        'last_x_ray',
        'comment',
        'swab_result',
        'remarks',
        'referral',
        'laboratory',
        'radiology',
        'prescription',
        'department',
        'sub_company',
        'category',
        'released',

        'updated_at',
        'created_at',
    ];

    public function scopeSearch($query, $search)
    {
        if ($search) {
            $query->where('employee_number', 'LIKE', "%$search%");
        }
        return $query;
    }

    public function illnesses()
    {
        return $this->belongsToMany(Illness::class)->withPivot('has_illness');
    }

    public function tobacco_uses()
    {
        return $this->belongsToMany(TobaccoUse::class)->withPivot('do_smoke');
    }

    public function skin_conditions()
    {
        return $this->belongsToMany(SkinCondition::class)->withPivot('has_skin_condition');
    }

    public function auscultates()
    {
        return $this->belongsToMany(Auscultate::class)->withPivot('has_auscultates');
    }

    public function diseases()
    {
        return $this->belongsToMany(Disease::class)->withPivot('has_disease')->withPivot('date');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function attendee()
    {
        return $this->belongsTo(Attendee::class);
    }

    public function physical_exams()
    {
        return $this->hasMany(PhysicalExam::class);
    }

    public function other_physical_exams()
    {
        return $this->hasMany(OtherPhysicalExam::class);
    }

    public function xrays()
    {
        return $this->hasMany(Xray::class);
    }

    public function certificates()
    {
        return $this->hasMany(Certificate::class);
    }

    public function swabs()
    {
        return $this->hasMany(Swab::class);
    }

    public function next_of_kins()
    {
        return $this->hasMany(NextOfKin::class);
    }

    public function home_address()
    {
        return $this->hasOne(HomeAddress::class);
    }

    public function medical_history()
    {
        return $this->hasOne(MedicalHistory::class);
    }

    public function pneumoconiosis()
    {
        return $this->hasOne(Pneumoconiosis::class);
    }

    public function fremarks()
    {
        return $this->hasMany(FRemarks::class);
    }

    public function cardio_vascular()
    {
        return $this->hasOne(CardioVascular::class);
    }

    public function icomments_remarks()
    {
        return $this->hasOne(ICommentRemarks::class);
    }

    public function respiratory_check()
    {
        return $this->hasOne(RespiratoryCheck::class);
    }

    public function medical_records()
    {
        return $this->hasMany(MedicalRecord::class);
    }

    public function latestCertificate()
    {
        return $this->hasOne(Certificate::class)->latestOfMany();
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'category_patient');
    }

/**
 * Legacy compatibility: returns the single string column (or the first pivot name)
 */
    public function getPrimaryCategoryAttribute(): ?string
    {
        if (! empty($this->category)) {
            return $this->category;
        }
        $c = $this->relationLoaded('categories') ? $this->categories->first() : $this->categories()->first();
        return $c?->name;
    }
}
