<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;


class PatientAttendance extends MedicalsModel
{
    use HasFactory;


    protected $fillable = [
        'user_id',
        'check_in',
        'check_out'
    ];

    // public function user()
    // {
    //     return $this->belongsTo(User::class);
    // }

    public function scopeCheckInUsersToday($query)
    {
        return $query->whereDate('check_in', Carbon::today());
    }
}
