<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PhysicalExam extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'weight',
        'height',
        'bp_sys',
        'bp_dia',
        'bmi',
        'bmi_status',
        'first_bp_time',
        'left_vision',
        'right_vision',
        'bp_status',
        'last_bp_time',
        'referral_comment',
        'temp',
        'pulse',
        'blood_sugar'

    ];

    public function patient()
    {
        return $this->belongsTo(PhysicalExam::class);
    }
}
