<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PhysicalTest extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'healthy_questionnaire_id',
        'weight',
        'height',
        'bp_sys',
        'bp_dia',
        'bmi',
        'bmi_status',
        'bp_status',
        'first_bp_time',
        'bp_repeat_sys',
        'bp_repeat_dia',
        'last_bp_time',
        'pulse',
        'rhythm',
        'general_exam',
        'abnormal_details',
    ];


    public function healthy_questionnaire()
    {
        return $this->belongsTo(HealthyQuestionnaire::class);
    }
}
