<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pneumoconiosis extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'company_id',
        'expiration_date',
        'exam_purpose',
        'created_at',
        'updated_at',
        
    ];

    public function patient(){
        return $this->belongsTo(Patient::class);
    }


    public function industry_classification(){
        return $this->hasOne(IndustryClassification::class);
    }

    public function mineral_dust_exposure(){
        return $this->hasOne(MineralDustExposure::class);
    }

    public function control_measure(){
        return $this->hasOne(ControlMeasure::class);
    }

    public function healthy_questionnaire(){
        return $this->hasOne(HealthyQuestionnaire::class);
    }

    public function results_investigation(){
        return $this->hasOne(ResultsInvestigations::class);
    }
}

