<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RespiratoryCheck extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'lungs',
        'x_ray_comment',
        'spirometry_comment',
        'fev',
        'fvc',
        'sears',
        'tenderness',
        'hernia',
        'organomegaly',
        'kidney_enlargement',
        'urine_appear',
        'sg',
        'albumin',
        'sugar',
        'deposit',
        'evidence_of_disease',
        'evidence_of_any_disease',
        'lmp',
        'parity'
    ];

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
}
