<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResultsInvestigations extends MedicalsModel
{
    use HasFactory;

    protected $fillable = [
        'pneumoconiosis_id',
        'chest_x_ray',
        'x_ray_comments',
        'fev1',
        'fev1_fvc',
        'fvc',
        'sfde_comment',
        'conclusion',
        'suitable_for_dusty',
        'suitable_for_dusty_comments',
        'other_medical_conditions',
        'conditions_details',
        'tb_comment',
        'referral',
    ];

    protected $casts = [
        'chest_x_ray' => 'boolean',
        'suitable_for_dusty' => 'boolean',
        'other_medical_conditions' => 'boolean',
        'referral' => 'boolean',
    ];


    public function pneumoconiosis()
    {
        return $this->belongsTo(Pneumoconiosis::class);
    }

    public function additional_test()
    {
        return $this->hasOne(AdditionalTest::class);
    }
}
