<?php

namespace App\Models\Medicals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SystemsCheck extends Model
{
    use HasFactory;

    protected $fillable = [
        'healthy_questionnaire_id',
        'respiratory',
        'cvs',
        'musculoskeletal',
        'cns',
        'skin',
        'systems_summary',
    ];

    protected $casts = [
        'respiratory' => 'boolean',
        'cvs' => 'boolean',
        'musculoskeletal' => 'boolean',
        'cns' => 'boolean',
        'skin' => 'boolean',
    ];

    public function healthy_questionnaire(){
        return $this->belongsTo(HealthyQuestionnaire::class);
    }
}
