<?php

namespace App\Models\Medicals;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Xray extends MedicalsModel
{
    use HasFactory;


    protected $fillable = [
        'status',
        'image',
        'result',
        'patient_id'
    ];

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }

    public function medical_record(): BelongsTo
    {
        return $this->belongsTo(MedicalRecord::class);
    }
    
}
