<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class MedicationBatch extends Model
{
    protected $fillable = [
        'medication_id',
        'central_store_id',
        'supplier_id',
        'batch_number',
        'quantity',
        'expiry_date',
        'manufacture_date',
        'received_date',
        'invoice_number',
        'price',
        'invoice_file', // Store file path

    ];

    /**
     * The medication this batch belongs to.
     */
    public function medication(): BelongsTo
    {
        return $this->belongsTo(Medication::class);
    }

    /**
     * The central store this batch is stored in.
     */
    public function centralStore(): BelongsTo
    {
        return $this->belongsTo(CentralStore::class);
    }

    /**
     * The supplier who provided this batch.
     */
    public function supplier(): BelongsTo
    {
        return $this->belongsTo(Supplier::class);
    }

    /**
     * Clinic-level stocks distributed from this batch.
     */
    public function clinicStocks(): HasMany
    {
        return $this->hasMany(ClinicMedicationStock::class);
    }
}
