<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MedicationRequest extends Model
{
    protected $fillable = [
        'clinic_id',
        'medication_id',
        'quantity',
        'transferred_quantity',
        'request_date',
        'status', // e.g., 'pending', 'approved', 'rejected'
    ];

    // Relationships

    public function clinic(): BelongsTo
    {
        return $this->belongsTo(Clinic::class);
    }

    public function medication(): BelongsTo
    {
        return $this->belongsTo(Medication::class);
    }
}
