<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Module extends Model
{
    /**
     * Common module slugs used across the app.
     */
    public const PRIMARY   = 'primary';
    public const DENTAL    = 'dental';
    public const CHRONICS  = 'chronics';
    public const SECONDARY = 'secondary';
    public const MEDICALS  = 'medicals';

    /**
     * Mass-assignable attributes.
     */
    protected $fillable = [
        'slug', // unique machine name, e.g. "primary"
        'name', // human-readable label, e.g. "Primary Health"
    ];

    /**
     * Casting.
     */
    protected $casts = [
        'slug' => 'string',
        'name' => 'string',
    ];

    /**
     * Users that have access to this module (via user_module_accesses).
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'user_module_accesses')
            ->withTimestamps();
    }

    /**
     * Scope: find by slug(s).
     *
     * Example:
     *  Module::slug('dental')->first();
     *  Module::slug(['dental','chronics'])->get();
     */
    public function scopeSlug($query, string|array $slug)
    {
        return is_array($slug)
            ? $query->whereIn('slug', $slug)
            : $query->where('slug', $slug);
    }
}
