<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NurseMedicationStock extends Model
{
    protected $fillable = [
        'nurse_id', // user id
        'clinic_id',
        'medication_batch_id',
        'quantity',
    ];

    public function nurse(): BelongsTo
    {
        return $this->belongsTo(User::class, 'nurse_id');
    }

    public function clinic(): BelongsTo
    {
        return $this->belongsTo(Clinic::class);
    }

    public function medicationBatch(): BelongsTo
    {
        return $this->belongsTo(MedicationBatch::class, 'medication_batch_id');
    }
}
