<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RadiologyOrder extends Model
{

    protected $fillable = [
        'patient_id',
        'consultation_id',
        'radiology_type',
        'status',
        'report_notes',
        'result_file',
        'ordered_by',
        'radiologist_id',
        'completed_at',
    ];

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }

    public function consultation()
    {
        return $this->belongsTo(Consultation::class);
    }

    public function orderedBy()
    {
        return $this->belongsTo(User::class, 'ordered_by');
    }

    public function radiologist()
    {
        return $this->belongsTo(User::class, 'radiologist_id');
    }

}
