<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class StockTransfer extends Model
{
    protected $fillable = [
        'from_central_store_id',
        'to_clinic_id',
        'medication_batch_id',
        'quantity',
        'transfer_date',
        'transferred_by',
        'transferred_quantity',
        'notes',
        'status',
        'approved_by',
        'approved_at',
    ];

    // Relationships

    public function fromCentralStore(): BelongsTo
    {
        return $this->belongsTo(CentralStore::class, 'from_central_store_id');
    }

    public function toClinic(): BelongsTo
    {
        return $this->belongsTo(Clinic::class, 'to_clinic_id');
    }

    public function medicationBatch(): BelongsTo
    {
        return $this->belongsTo(MedicationBatch::class);
    }

    public function transferredBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'transferred_by');
    }

    public function approvedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
