<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Supplier extends Model
{
    protected $fillable = [
        'name',
        'email',
        'phone',
        'contact_person',
        'address',
        'city',
        'province',
        'country',
        'notes',
    ];

    public function medicationBatches(): HasMany
    {
        return $this->hasMany(MedicationBatch::class);
    }
}
