<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Triage extends Model
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'clinic_id',
        'nurse_id',
        'consultor_id',
        'consultation_id',
        'triage_level',
        'bill_type',
        'bill_class',
        'payment_point',
        'payment_method',
        'chief_complaint',
        'notes',
        'is_active', // to mark if the triage is still active or not
    ];

    // Relationships
    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }

    public function clinic()
    {
        return $this->belongsTo(Clinic::class);
    }

    public function nurse()
    {
        return $this->belongsTo(User::class, 'nurse_id');
    }

    public function consultor()
    {
        return $this->belongsTo(User::class, 'consultor_id');
    }

    public function consultation()
    {
        return $this->belongsTo(Consultation::class);
    }

    public function paymentCompany()
    {
        return $this->belongsTo(Company::class, 'payment_point');
    }
}
