<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserModuleAccess extends Model
{
    protected $table = 'user_module_accesses';

    // Allow these to be mass assigned
    protected $fillable = [
        'user_id',
        'module_id',
        'is_enabled',  // ← important
    ];

    protected $casts = [
        'user_id'    => 'integer',
        'module_id'  => 'integer',
        'is_enabled' => 'boolean',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function module(): BelongsTo
    {
        return $this->belongsTo(Module::class);
    }
}
